require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require_relative '../base/base'
require_relative '../../common/common'

class CommunityCare < Base
  include PageObject

  def initialize(driver)
    super(driver)
    @common = Common.new(@driver)
  end
  div(:page_loader, :css => "body > div.ui-loader.ui-corner-all.ui-body-a.ui-loader-verbose")

  #Step 1: Service, Step:2
  button(:new_appt_reqst_btn, :id => 'heading-new-appointment-request-btn')
  button(:app_request_bak, :css => '#back-btn')
  div(:new_cc_reqst_form, :css => ".field-container")
  button(:exit_button, :css => "#exit-btn")
  button(:continue_btn, :css => "#continue-btn")
  elements(:radio_btn, :radio ,:css => "input[id^='service']")
  div(:distance_eligibility, :css => ".distance-travel-selection-section")
  div(:unusual_question, :css => ".distance-travel-selection-section .unusual-travel")
  div(:travel_distance_question, :css =>".distance-travel-selection-section .travel-distance")
  legend(:distance_eligible_vet, :css => "legend[for='distanceEligible']" )
  radio_button(:eligibility_yes, :css => "#distanceEligible-yes")
  radio_button(:eligibility_no, :css => "#distanceEligible-no")
  radio_button(:travel_yes, :css => "#travelBurden-yes")
  radio_button(:travel_no, :css => "#travelBurden-no")
  radio_button(:unusual_yes, :css => "#unusualTravelBurden-yes")
  radio_button(:unusual_no, :css => "#unusualTravelBurden-no")
  elements(:select_location, :css=>'.ui-corner-all label[for*=\'facility\'] span:nth-child(1)')
  div(:address_container, :css => ".community-care-input")
  text_field(:address, :css=> "#address")
  text_field(:city, :id => 'city')
  select_list(:state, :id => 'state')
  text_field(:zip_code_1st_question, :id => 'zipCode')
  button(:find_nearest_facility, :css => "#find-facility-btn")
  p(:eligibility_response, :css => "#eligibilityResponse")
  a(:ext_facility_locator, :css => "#eligibilityResponse a")
  div(:unsupported_instr_text, :css => ".label-text.label-details")
  button(:back_button, :css => "#back-btn")

  # Step 3 and 4 elements
  div(:facility_section, :css => ".facility-selection-section")
  elements(:facility_radio_btn, :radio, :css =>"[id^='facility']")
  elements(:facility_label, :css =>"[for^='facility'] .label-text span")
  button(:previous_btn, :css => "#previous-btn")
  legend(:step3_text, :css => '.facility-selection-section .step-instruction-heading')
  p(:step3_instruction, :css => '.step-instructions')
  span(:select_facility, :css => "[for^='facility'] .label-text")
  div(:disabled_label_facility, :css => "[for^='facility'] .label-text .label-details")
  span(:static_facility_name, :css =>"#facility.static-text")

  # CareType Section Layout
  div(:care_type_section, :css => ".caretype-selection-section")
  select_list(:care_type, :css => "#careType")
  elements(:type_of_care, :css=>'#careType option')
  radio_button(:con_yes, :css => "#careTypeContinue-yes")
  radio_button(:con_no, :css => "#careTypeContinue-no")
  span(:info_text, :css => ".caretype-details .static-text")
  span(:care_typ_details, :css => ".caretype-details .static-text")
  div(:care_type_continue, :css => ".caretype-continue")
  span(:no_custm_msg, :css => ".caretype-confirmation .static-text")
  div(:error_msg, :css => ".error-section")

  # Step 4/5 Appointment Preferences Wizard
  legend(:step_heading, :css=>'.step-instruction-heading')
  form(:apt_preferences, :css => "#new-appointment-request-form")
  text_field(:choice1_date, :css => "#optionDate1")
  text_field(:choice2_date, :css => "#optionDate2")
  text_field(:choice3_date, :css => "#optionDate3")
  elements(:radio_am_pm, :radio, :css => "[id^=optionTime]")
  text_field(:zip_code, :id => 'primaryZipCode')
  elements(:pref_mile,:radio,:id => 'primaryPreferredMiles')
  div(:zip_code_error, :css => "#preferredZipcode-error-inline")
  elements(:office_hours, :css=>'.ui-corner-all label[for*=\'officeHours\'] span')
  elements(:invalid_date_error, :css => "[id^='optionDate'][id$='error-inline']")
  element(:preferred_provider_instruction, :css=>'.preferred-appointment-location .step-instructions')

  # Provider Preference
  form(:provider_pref, :css =>'#new-appointment-request-form')
  text_field(:provider_city, :id => 'primaryCity')
  select_list(:provider_state, :id => 'primaryState')
  elements(:preferred_state, :css=>'#primaryState option')
  text_field(:provider_zip, :id => 'primaryZipCode')
  elements(:preferred_miles, :radio, :css => "[id^='primaryPreferredMiles']")
  elements(:select_miles, :css=>'label[for^=\'primaryPreferredMiles\'] span')
  select_list(:preferred_lang, :id => 'preferredLanguageSpoken')
  elements(:select_language, :css=>'#preferredLanguageSpoken option')
  elements(:office_hrs, :css => "[id^='officeHours']")


  # Notification Settings Wizard

  form(:notification_form, :css => "#new-appointment-request-form")
  p(:step7_instructions, :css => ".step-instructions")
  text_field(:phone_required, :css => "#phoneNumber")
  div(:phone_call_settings, :css => ".community-care-settings")
  elements(:best_timeCall, :css => "[id^='bestTimetoCall']")
  checkbox(:evening_call, :css => "#bestTimeToCall-evening")
  checkbox(:morning_call, :css => "#bestTimeToCall-morning")
  checkbox(:afternoon_call, :css => "#bestTimeToCall-afternoon")
  radio_button(:phoneCall_requestYes, :css => "#requestedPhoneCall-yes")
  radio_button(:phoneCall_requestNo, :css => "#requestedPhoneCall-no")
  div(:clerk_msg_section, :css => ".request-details-new-message-section")
  text_area(:clerk_msg, :css => "#newMessage")
  div(:email_pref_section, :css => ".email-preferences-section")
  radio_button(:email_yes, :css => "#emailAllowed-yes")
  radio_button(:email_no, :css => "#emailAllowed-no")
  text_field(:email_field, :css => "#emailAddress")
  button(:submit_request, :css => "#submit-btn")
  legend(:email_notification_label, :css => ".email-preferences-section .form-section-heading")
  elements(:email_instruction, :css => ".required-email")
  text_area(:msg_clerk, :css => "#newMessage")

  #Request Details Page
  div(:request_details_1, :css => "#main-content > div > div > div:nth-child(4) > div:nth-child(1) > div:nth-child(2)")
  div(:request_details_2, :css => "#main-content > div > div > div:nth-child(4) > div:nth-child(1) > div:nth-child(4)")
  div(:request_details_3, :css => "#main-content > div > div > div:nth-child(4) > div:nth-child(1) > div:nth-child(6)")
  div(:request_details_4, :css => "#main-content > div > div > div:nth-child(4) > div:nth-child(1) > div:nth-child(8)")
  h3(:request_eligibility_section_1, :css => "#request-eligibility-section .details-header")
  div(:request_eligibility_section_2, :css => "#request-eligibility-section >div>div")
  h2(:communicating_with_a_clerk_header, :css => "#request-appointment-messages > div > div:nth-child(1) > h2")
  span(:submitted_date, :css => "#main-content > div > div > div:nth-child(4) > div:nth-child(1) > div:nth-child(2) > div.field-set.field-set-indent > div:nth-child(1) > span.field-value")
  span(:request_Status, :css => ".request-status")
  p(:request_status_msg, :css => ".request-status-desc")
  span(:request_submit_date, :css => ".request-status-last-updated .field-value")
  div(:phone_error, :css => "#phoneNumber-error-inline")
  div(:email_error, :css => "#emailAddress-error-inline")

  elements(:contact_info, :css => "#your-contact-information+.request-details-group.request-details-group.request-details-group .field-contain")
  elements(:request_details_status, :css => "#request-appointment-status p")
  div(:provider_preference_sec, :css => "#provider-preference-region")
  div(:preferred_Date_Time, :css => "#preferred-appointment-date-time + div" )
  div(:contact_info_details_view, :css => "#your-contact-information + .request-details-group")
  div(:eligibility_details_section, :css => "#request-eligibility-section>.request-details-section")
  button(:cancel_cc_btn, :css => "#cancel-request-btn")
  button(:send_msg_btn, :css => "#send-message-btn")
  elements(:msg_to_clerk, :css => "#request-messages-log .message-text")
  div(:msg_log, :css => "#request-messages-log")
  text_area(:msg_details_clerk, :css => "#new-message")

  #Appointment List View Page
  div(:cc_request_details, :css => "#appointment-status-group+div+div")
  div(:cc_prepare_for_appt, :css => ".cc-provider-instructions-section .modal-content")


  #booked pcp details view
  p(:cc_request_status, :css => ".request-status-desc")
  div(:cc_booked_pcp, :css => "#booked-pcp-appointment .request-details-group")
  div(:pcp_instruction, :css => "#booked-pcp-instructions .appointments")


  #Provider Preferences
  select(:preferred_language, :id => 'preferredLanguageSpoken')
  radio_button(:miles_10, :id => 'primaryPreferredMiles-10')
  checkbox(:weekdays, :id => 'officeHours-weekdays')
  checkbox(:evenings, :id => 'officeHours-evenings')
  checkbox(:weekends, :id => 'officeHours-weekends')
  div(:preferred_providers_all_fields, :css => "#new-appointment-request-form > div.current-wizard-page-layout > div > div.field-container.unusual-container > div.flex-questions > div.primary-provider > div > div")
  button(:add_provider, :css => '#add-provider')
  elements(:additional_providerFirstName, :css => '#firstName')
  elements(:additional_providerLastName, :css => '#lastName')
  elements(:additional_providerPractice, :css => '#practiceName')
  elements(:additional_providerStreet, :css => '#providerStreet')
  elements(:additional_providerCity, :css => '#providerCity')
  elements(:additional_providerState, :css => '#providerState')
  elements(:additional_providerZIP, :css => '#providerZipCode')
  legend(:provider_1_header, :css=> "fieldset[id='1'] legend")
  legend(:provider_2_header, :css => "fieldset[id='2'] legend")
  legend(:provider_3_header, :css=> "fieldset[id='3'] legend")
  div(:primary_provider_2_fields, :css => ".primary-provider2")
  div(:primary_provider_3_fields, :css => ".primary-provider3")
  div(:additional_appt_preferences_field, :css => "#new-appointment-request-form > div.current-wizard-page-layout > div > div.field-container.unusual-container > div.flex-questions > div.additonal-preferences > fieldset > div")

  #Request list - PCP Request
  span(:pcp_request, :xpath => "//span[contains(text(),'Primary Care (find a provider)')]")
  div(:request_table, :css => "#requested-appointments-table-list")

  def distanceElibleVeteran(option)
    distance_eligibility_element.when_present(TIME_OUT_LIMIT)
    if (option.downcase == "yes")
      eligibility_yes_element.click
    elsif (option.downcase == "no")
      eligibility_no_element.click
    end
  end

  def clickContinueButton()
    continue_btn_element.when_present(TIME_OUT_LIMIT)
    wait_until{ !continue_btn_element.attribute('disabled') }
    self.execute_script("arguments[0].scrollIntoView();", continue_btn_element)
    continue_btn
    @common.waitWhileSpinnerPresent
  end

  def selectLocation(location)
    wait_until{ !facility_section_element.attribute('disabled') }
    facility_section_element.when_present(TIME_OUT_LIMIT)
    options = self.select_location_elements
    selectOption(options, location)
    @common.waitWhileSpinnerPresent
  end

  def selectTypeOfCare(typeofcare)
    care_type_section_element.wait_until_present(TIME_OUT_LIMIT)
    options = self.type_of_care_elements
    selectOption(options, typeofcare)
    @common.waitWhileSpinnerPresent

  end

  def selectState(state)
    provider_state_element.when_present(TIME_OUT_LIMIT)
    options = self.preferred_state_elements
    selectOption(options, state)
    @common.waitWhileSpinnerPresent
  end

  def selectMiles(miles)
    preferred_miles_elements[0].when_present(TIME_OUT_LIMIT)
    options = self.select_miles_elements
    selectOption(options, miles)
    @common.waitWhileSpinnerPresent
  end

  def selectLanguage(language)
    preferred_lang_element.when_present(TIME_OUT_LIMIT)
    options = self.select_language_elements
    selectOption(options, language)
    @common.waitWhileSpinnerPresent

  end

  def selectOfficeHours(officeHours)
    options = self.office_hours_elements
    if(officeHours == "all")
      selectOption(options, "Weekdays")
      selectOption(options, "Evenings")
      selectOption(options, "Weekends")
    else
      selectOption(options, officeHours)
    end
    @common.waitWhileSpinnerPresent

  end

  def provideLocationDetails(city, state, zip, miles, language, officeHours)
    self.provider_city = city
    self.selectState(state)
    self.provider_zip =zip
    self.selectMiles(miles)
    self.selectLanguage(language)
    self.selectOfficeHours(officeHours)
  end

  def clickAddProvider
    self.execute_script("arguments[0].scrollIntoView();", exit_button_element)
    self.add_provider_element.when_present(TIME_OUT_LIMIT)
    wait_until{ !add_provider_element.attribute('disabled') }
    self.add_provider
  end
end